/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.player;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.spell.item.ItemSpell;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class YukariItemSpellLaser
extends ItemSpell {
    @Override
    public void start(Player player, @Nullable LivingEntity target) {
        super.start(player, target);
        this.addTicker(new LaserAdder());
    }

    @SerialClass
    public static class LaserAdder
    extends Ticker<YukariItemSpellLaser> {
        @SerialClass.SerialField
        private Vec3 pos;
        @SerialClass.SerialField
        private Vec3 forward;

        @Override
        public boolean tick(CardHolder holder, YukariItemSpellLaser card) {
            if (this.tick == 0) {
                this.forward = holder.forward();
                this.forward = this.forward.m_82542_(1.0, 0.5, 1.0).m_82541_();
                this.pos = holder.center();
            }
            DanmakuHelper.Orientation ori = DanmakuHelper.getOrientation(this.forward);
            RandomSource r = holder.random();
            this.addLaserBeams(holder, this.pos, ori.rotateDegrees(-45.0), 1.0 + (double)this.tick * 0.5, r.m_188500_(), DyeColor.RED);
            this.addLaserBeams(holder, this.pos, ori.rotateDegrees(45.0), 1.0 + (double)this.tick * 0.5, r.m_188500_(), DyeColor.BLUE);
            if (this.tick == 20) {
                this.shootGroup(holder, DyeColor.RED);
            }
            if (this.tick == 40) {
                this.shootGroup(holder, DyeColor.BLUE);
            }
            super.tick(holder, card);
            return this.tick > 120;
        }

        private void shootGroup(CardHolder holder, DyeColor color) {
            int lf;
            Vec3 vec;
            double sp;
            double d1;
            double d0;
            int i;
            double speed = 1.0;
            double dv = 0.5;
            double dev = 30.0;
            int n0 = 5;
            int n1 = 50;
            int life = 60;
            int dl = 20;
            Vec3 forward = holder.forward();
            RandomSource rand = holder.random();
            DanmakuHelper.Orientation ori = DanmakuHelper.getOrientation(forward);
            for (i = 0; i < n0; ++i) {
                d0 = (rand.m_188500_() * 2.0 - 1.0) * dev * (double)i / (double)n0;
                d1 = (rand.m_188500_() * 2.0 - 1.0) * dev * (double)i / (double)n0;
                sp = speed - dv / (double)n0 * (double)i;
                vec = ori.rotateDegrees(d0, d1).m_82490_(sp);
                lf = life + rand.m_188503_(dl);
                holder.shoot(holder.prepareDanmaku(lf, vec, YHDanmaku.Bullet.BUBBLE, color));
            }
            for (i = 0; i < n1; ++i) {
                d0 = (rand.m_188500_() * 2.0 - 1.0) * dev * (double)i / (double)n1;
                d1 = (rand.m_188500_() * 2.0 - 1.0) * dev * (double)i / (double)n1;
                sp = speed - dv / (double)n1 * (double)i;
                vec = ori.rotateDegrees(d0, d1).m_82490_(sp);
                lf = life + rand.m_188503_(dl);
                holder.shoot(holder.prepareDanmaku(lf, vec, YHDanmaku.Bullet.MENTOS, color));
            }
        }

        private void addLaserBeams(CardHolder holder, Vec3 pos, Vec3 dir, double step, double r, DyeColor color) {
            Vec3 p = pos.m_82549_(dir.m_82490_(step));
            Vec3 ori = DanmakuHelper.getOrientation(dir).rotate(1.5707963267948966, r * Math.PI * 2.0);
            holder.shoot(holder.prepareLaser(100, p, ori, 80.0f, YHDanmaku.Laser.LASER, color));
        }
    }
}

